/*:
 * @target MZ
 * @plugindesc HS_FastMode × LL_CustomFade 互換：高速ON時はフェードdurationも短縮（保護中は無効）
 * @author HS
 */
(() => {
  "use strict";
  const HSP = PluginManager.parameters("HS_FastMode") || {};
  const INT_DIV = Math.max(1, Number(HSP["InterpreterWaitDivisor"] || 2));
  function fastOn() {
    const blocked = window.HS_FM ? window.HS_FM.isBlocked() : false;
    return !!ConfigManager.fastMode && !blocked && INT_DIV > 1;
  }
  const _startFadeOut = Game_Screen.prototype.startFadeOut;
  Game_Screen.prototype.startFadeOut = function (duration) {
    if (fastOn()) duration = Math.max(1, Math.floor(duration / INT_DIV));
    _startFadeOut.call(this, duration);
  };
  const _startFadeIn = Game_Screen.prototype.startFadeIn;
  Game_Screen.prototype.startFadeIn = function (duration) {
    if (fastOn()) duration = Math.max(1, Math.floor(duration / INT_DIV));
    _startFadeIn.call(this, duration);
  };
})();
